unit KnobTestForm;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, Examples.WinForms.Knobs;


type
  TKnobTestForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variables.
    /// </summary>
    Components: System.ComponentModel.Container;
    Knob1: Examples.WinForms.Knobs.Knob;
    Button1: System.Windows.Forms.Button;
    NumericUpDown1: System.Windows.Forms.NumericUpDown;
    Label1: System.Windows.Forms.Label;
    Label2: System.Windows.Forms.Label;
    NumericUpDown2: System.Windows.Forms.NumericUpDown;
    Button2: System.Windows.Forms.Button;
    ComboBox1: System.Windows.Forms.ComboBox;
    Label3: System.Windows.Forms.Label;
    ColorDialog1: System.Windows.Forms.ColorDialog;
    Button3: System.Windows.Forms.Button;
    Button4: System.Windows.Forms.Button;
    GroupBox1: System.Windows.Forms.GroupBox;
    Button5: System.Windows.Forms.Button;
    Label4: System.Windows.Forms.Label;
    NumericUpDown3: System.Windows.Forms.NumericUpDown;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure Button1_Click(sender: System.Object; e: System.EventArgs);
    procedure NumericUpDown1_ValueChanged(sender: System.Object; e: System.EventArgs);
    procedure NumericUpDown2_ValueChanged(sender: System.Object; e: System.EventArgs);
    procedure Button2_Click(sender: System.Object; e: System.EventArgs);
    procedure TKnobTestForm_Load(sender: System.Object; e: System.EventArgs);
    procedure Knob1_DrawPointer(sender: System.Object; e: Examples.WinForms.Knobs.KnobDrawEventArgs);
    procedure Button3_Click(sender: System.Object; e: System.EventArgs);
    procedure Button4_Click(sender: System.Object; e: System.EventArgs);
    procedure Button5_Click(sender: System.Object; e: System.EventArgs);
    procedure ComboBox1_SelectedIndexChanged(sender: System.Object; e: System.EventArgs);
    procedure NumericUpDown3_ValueChanged(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  public
    constructor Create;
  end;

implementation

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TKnobTestForm.InitializeComponent;
type
        TIntegerArray = array of Integer;
        TSystem_ObjectArray = array of System.Object;
begin
        Self.ColorDialog1 := System.Windows.Forms.ColorDialog.Create;
        Self.GroupBox1 := System.Windows.Forms.GroupBox.Create;
        Self.NumericUpDown3 := System.Windows.Forms.NumericUpDown.Create;
        Self.Label4 := System.Windows.Forms.Label.Create;
        Self.Button4 := System.Windows.Forms.Button.Create;
        Self.Button3 := System.Windows.Forms.Button.Create;
        Self.Label3 := System.Windows.Forms.Label.Create;
        Self.ComboBox1 := System.Windows.Forms.ComboBox.Create;
        Self.Button2 := System.Windows.Forms.Button.Create;
        Self.NumericUpDown2 := System.Windows.Forms.NumericUpDown.Create;
        Self.Label2 := System.Windows.Forms.Label.Create;
        Self.Label1 := System.Windows.Forms.Label.Create;
        Self.NumericUpDown1 := System.Windows.Forms.NumericUpDown.Create;
        Self.Button1 := System.Windows.Forms.Button.Create;
        Self.Knob1 := Examples.WinForms.Knobs.Knob.Create;
        Self.Button5 := System.Windows.Forms.Button.Create;
        Self.GroupBox1.SuspendLayout;
        (System.ComponentModel.ISupportInitialize(Self.NumericUpDown3)).BeginInit;
        (System.ComponentModel.ISupportInitialize(Self.NumericUpDown2)).BeginInit;
        (System.ComponentModel.ISupportInitialize(Self.NumericUpDown1)).BeginInit;
        Self.SuspendLayout;
        // 
        // GroupBox1
        // 
        Self.GroupBox1.Controls.Add(Self.NumericUpDown3);
        Self.GroupBox1.Controls.Add(Self.Label4);
        Self.GroupBox1.Controls.Add(Self.Button4);
        Self.GroupBox1.Controls.Add(Self.Button3);
        Self.GroupBox1.Controls.Add(Self.Label3);
        Self.GroupBox1.Controls.Add(Self.ComboBox1);
        Self.GroupBox1.Controls.Add(Self.Button2);
        Self.GroupBox1.Controls.Add(Self.NumericUpDown2);
        Self.GroupBox1.Controls.Add(Self.Label2);
        Self.GroupBox1.Controls.Add(Self.Label1);
        Self.GroupBox1.Controls.Add(Self.NumericUpDown1);
        Self.GroupBox1.Controls.Add(Self.Button1);
        Self.GroupBox1.Controls.Add(Self.Knob1);
        Self.GroupBox1.Location := System.Drawing.Point.Create(12, 16);
        Self.GroupBox1.Name := 'GroupBox1';
        Self.GroupBox1.Size := System.Drawing.Size.Create(480, 248);
        Self.GroupBox1.TabIndex := 0;
        Self.GroupBox1.TabStop := False;
        // 
        // NumericUpDown3
        // 
        Self.NumericUpDown3.Location := System.Drawing.Point.Create(348, 156);
        Self.NumericUpDown3.Name := 'NumericUpDown3';
        Self.NumericUpDown3.TabIndex := 26;
        Self.NumericUpDown3.Value := System.Decimal.Create(TIntegerArray.Create(50, 0, 0, 0));
        Include(Self.NumericUpDown3.ValueChanged, Self.NumericUpDown3_ValueChanged);
        // 
        // Label4
        // 
        Self.Label4.Location := System.Drawing.Point.Create(204, 156);
        Self.Label4.Name := 'Label4';
        Self.Label4.Size := System.Drawing.Size.Create(136, 24);
        Self.Label4.TabIndex := 25;
        Self.Label4.Text := 'Pointer size (0 - 100)';
        // 
        // Button4
        // 
        Self.Button4.Location := System.Drawing.Point.Create(300, 208);
        Self.Button4.Name := 'Button4';
        Self.Button4.Size := System.Drawing.Size.Create(80, 23);
        Self.Button4.TabIndex := 23;
        Self.Button4.Text := 'Pointer Color';
        Include(Self.Button4.Click, Self.Button4_Click);
        // 
        // Button3
        // 
        Self.Button3.Location := System.Drawing.Point.Create(204, 208);
        Self.Button3.Name := 'Button3';
        Self.Button3.Size := System.Drawing.Size.Create(80, 23);
        Self.Button3.TabIndex := 22;
        Self.Button3.Text := 'Color';
        Include(Self.Button3.Click, Self.Button3_Click);
        // 
        // Label3
        // 
        Self.Label3.Location := System.Drawing.Point.Create(204, 112);
        Self.Label3.Name := 'Label3';
        Self.Label3.Size := System.Drawing.Size.Create(136, 24);
        Self.Label3.TabIndex := 21;
        Self.Label3.Text := 'Pointer shape';
        // 
        // ComboBox1
        // 
        Self.ComboBox1.Items.AddRange(TSystem_ObjectArray.Create('Line', 'Triangle', 'Dot', 'OwnerDraw'));
        Self.ComboBox1.Location := System.Drawing.Point.Create(348, 112);
        Self.ComboBox1.Name := 'ComboBox1';
        Self.ComboBox1.Size := System.Drawing.Size.Create(121, 21);
        Self.ComboBox1.TabIndex := 20;
        Include(Self.ComboBox1.SelectedIndexChanged, Self.ComboBox1_SelectedIndexChanged);
        // 
        // Button2
        // 
        Self.Button2.Location := System.Drawing.Point.Create(108, 208);
        Self.Button2.Name := 'Button2';
        Self.Button2.Size := System.Drawing.Size.Create(80, 23);
        Self.Button2.TabIndex := 19;
        Self.Button2.Text := 'Remove ticks';
        Include(Self.Button2.Click, Self.Button2_Click);
        // 
        // NumericUpDown2
        // 
        Self.NumericUpDown2.Location := System.Drawing.Point.Create(348, 72);
        Self.NumericUpDown2.Maximum := System.Decimal.Create(TIntegerArray.Create(3600, 0, 0, 0));
        Self.NumericUpDown2.Name := 'NumericUpDown2';
        Self.NumericUpDown2.TabIndex := 18;
        Self.NumericUpDown2.Value := System.Decimal.Create(TIntegerArray.Create(3300, 0, 0, 0));
        Include(Self.NumericUpDown2.ValueChanged, Self.NumericUpDown2_ValueChanged);
        // 
        // Label2
        // 
        Self.Label2.Location := System.Drawing.Point.Create(204, 72);
        Self.Label2.Name := 'Label2';
        Self.Label2.Size := System.Drawing.Size.Create(136, 24);
        Self.Label2.TabIndex := 17;
        Self.Label2.Text := 'Maximum angle (0- 3600)';
        // 
        // Label1
        // 
        Self.Label1.Location := System.Drawing.Point.Create(204, 32);
        Self.Label1.Name := 'Label1';
        Self.Label1.Size := System.Drawing.Size.Create(136, 24);
        Self.Label1.TabIndex := 16;
        Self.Label1.Text := 'Minimum angle (0 - 3600)';
        // 
        // NumericUpDown1
        // 
        Self.NumericUpDown1.Location := System.Drawing.Point.Create(348, 32);
        Self.NumericUpDown1.Maximum := System.Decimal.Create(TIntegerArray.Create(3600, 0, 0, 0));
        Self.NumericUpDown1.Name := 'NumericUpDown1';
        Self.NumericUpDown1.TabIndex := 15;
        Self.NumericUpDown1.Value := System.Decimal.Create(TIntegerArray.Create(300, 0, 0, 0));
        Include(Self.NumericUpDown1.ValueChanged, Self.NumericUpDown1_ValueChanged);
        // 
        // Button1
        // 
        Self.Button1.Location := System.Drawing.Point.Create(12, 208);
        Self.Button1.Name := 'Button1';
        Self.Button1.Size := System.Drawing.Size.Create(80, 23);
        Self.Button1.TabIndex := 14;
        Self.Button1.Text := 'Set ticks';
        Include(Self.Button1.Click, Self.Button1_Click);
        // 
        // Knob1
        // 
        Self.Knob1.Angle := 300;
        Self.Knob1.BorderStyle := System.Windows.Forms.BorderStyle.None;
        Self.Knob1.ButtonEdge := 20;
        Self.Knob1.DefaultValue := 0;
        Self.Knob1.ForeColor := System.Drawing.Color.SlateGray;
        Self.Knob1.LargeChange := 2;
        Self.Knob1.Location := System.Drawing.Point.Create(12, 24);
        Self.Knob1.Maximum := 100;
        Self.Knob1.MaximumAngle := 3300;
        Self.Knob1.Minimum := 0;
        Self.Knob1.MinimumAngle := 300;
        Self.Knob1.Name := 'Knob1';
        Self.Knob1.PointerColor := System.Drawing.SystemColors.ControlText;
        Self.Knob1.PointerShape := Examples.WinForms.Knobs.KnobPointerShape.Line;
        Self.Knob1.PointerSize := 50;
        Self.Knob1.Radius := 68;
        Self.Knob1.RepeatDelay := 400;
        Self.Knob1.RepeatRate := 100;
        Self.Knob1.Size := System.Drawing.Size.Create(172, 160);
        Self.Knob1.SmallChange := 1;
        Self.Knob1.TabIndex := 13;
        Self.Knob1.TickFrequency := 5;
        Self.Knob1.TickStyle := Examples.WinForms.Knobs.KnobTickStyle.Auto;
        Self.Knob1.Value := 0;
        Include(Self.Knob1.DrawPointer, Self.Knob1_DrawPointer);
        // 
        // Button5
        // 
        Self.Button5.Location := System.Drawing.Point.Create(216, 288);
        Self.Button5.Name := 'Button5';
        Self.Button5.Size := System.Drawing.Size.Create(81, 23);
        Self.Button5.TabIndex := 1;
        Self.Button5.Text := 'Exit';
        Include(Self.Button5.Click, Self.Button5_Click);
        // 
        // TKnobTestForm
        // 
        Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
        Self.ClientSize := System.Drawing.Size.Create(504, 333);
        Self.Controls.Add(Self.Button5);
        Self.Controls.Add(Self.GroupBox1);
        Self.Name := 'TKnobTestForm';
        Self.Text := 'Delphi for the Microsoft .NET Framework demo';
        Include(Self.Load, Self.TKnobTestForm_Load);
        Self.GroupBox1.ResumeLayout(False);
        (System.ComponentModel.ISupportInitialize(Self.NumericUpDown3)).EndInit;
        (System.ComponentModel.ISupportInitialize(Self.NumericUpDown2)).EndInit;
        (System.ComponentModel.ISupportInitialize(Self.NumericUpDown1)).EndInit;
        Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TKnobTestForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TKnobTestForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TKnobTestForm.NumericUpDown3_ValueChanged(sender: System.Object; e: System.EventArgs);
begin
  Knob1.PointerSize := Decimal.ToInt32(NumericUpDown3.Value);
end;

procedure TKnobTestForm.ComboBox1_SelectedIndexChanged(sender: System.Object;
    e: System.EventArgs);
begin
  case ComboBox1.SelectedIndex of
    0: Knob1.PointerShape := KnobPointerShape.Line;
    1: Knob1.PointerShape := KnobPointerShape.Triangle;
    2: Knob1.PointerShape := KnobPointerShape.Dot;
    else
      Knob1.PointerShape := KnobPointerShape.OwnerDraw;
  end;
end;

procedure TKnobTestForm.Button5_Click(sender: System.Object; e: System.EventArgs);
begin
  Close;
end;

procedure TKnobTestForm.Button4_Click(sender: System.Object; e: System.EventArgs);
begin
  ColorDialog1.Color := Knob1.PointerColor;
  if ColorDialog1.ShowDialog = System.Windows.Forms.DialogResult.OK then
    Knob1.PointerColor := ColorDialog1.Color;
end;

procedure TKnobTestForm.Button3_Click(sender: System.Object; e: System.EventArgs);
begin
  ColorDialog1.Color := Knob1.ForeColor;
  if ColorDialog1.ShowDialog = System.Windows.Forms.DialogResult.OK then
    Knob1.ForeColor := ColorDialog1.Color;
end;

procedure TKnobTestForm.Knob1_DrawPointer(sender: System.Object; e: Examples.WinForms.Knobs.KnobDrawEventArgs);
var
  R: Rectangle;
  Gradient: System.Drawing.Brush;
  Pen: System.Drawing.Pen;
begin
  R := e.DrawRect;
  R.Inflate(-1, -1);

  Gradient := Knob.SlantedGradient(R, -135.0, Knob1.LightColor,
    Knob1.FaceColor, Knob1.DarkColor);

  e.Graphics.FillEllipse(Gradient, R);
  Pen := System.Drawing.Pen.Create(Knob1.FaceColor);
  e.Graphics.DrawEllipse(Pen, R);
  Pen.Free;
end;

procedure TKnobTestForm.TKnobTestForm_Load(sender: System.Object; e: System.EventArgs);
begin
  ComboBox1.SelectedIndex := 0;
end;

procedure TKnobTestForm.Button2_Click(sender: System.Object; e: System.EventArgs);
begin
  Knob1.ClearTick(3);
  Knob1.ClearTick(97);
end;

procedure TKnobTestForm.NumericUpDown2_ValueChanged(sender: System.Object; e: System.EventArgs);
begin
  Knob1.MaximumAngle := Decimal.ToInt32(NumericUpDown2.Value);
end;

procedure TKnobTestForm.NumericUpDown1_ValueChanged(sender: System.Object; e: System.EventArgs);
begin
  Knob1.MinimumAngle := Decimal.ToInt32(NumericUpDown1.Value);
end;

procedure TKnobTestForm.Button1_Click(sender: System.Object; e: System.EventArgs);
begin
  Knob1.SetTick(3, KnobTickLength.Long, Color.Red);
  Knob1.SetTick(97, KnobTickLength.Long, Color.Red);
end;

end.

